using System;
using System.Text;
using System.Data.SqlClient;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class _Default : System.Web.UI.Page
{
   public CompanyEventControl companyControl = new CompanyEventControl();
   public LocationEventControl locationControl = new LocationEventControl();

   protected void Page_Load(object sender, EventArgs e)
   {
      ClientScriptManager cm = Page.ClientScript;
      this.AddParsedSubObject(companyControl);
      string cbRef = cm.GetCallbackEventReference(companyControl,
        "companyId", "CallBackReturnFunction", "oContext", "OnError", false);
      StringBuilder sb = new StringBuilder();
      sb.Append(
        "<script language=\"javascript\">function OnCompanyClick(companyId)\n");
      sb.Append(
        "{ var oContext = new Object(); oContext.CommandName = \"GetLocationsByCompanyID\";\n");
      sb.Append("oContext.CompanyID = companyId;\n");
      sb.AppendFormat("{0};\n", cbRef);
      sb.Append("}\n</script>");
      cm.RegisterClientScriptBlock(this.GetType(), "OnCompanyClick", sb.ToString());

      this.AddParsedSubObject(locationControl);
      string cbRef2 = cm.GetCallbackEventReference(locationControl,
        "locationId", "CallBackReturnFunction2", "oContext", "OnError", false);
      sb = new StringBuilder();
      sb.Append(
        "<script language=\"javascript\">function OnLocationClick(locationId)\n");
      sb.Append(
        "{ var oContext = new Object(); oContext.CommandName = \"GetOfficesByLocation\";\n");
      sb.Append("oContext.LocationID = locationId;\n");
      sb.AppendFormat("{0};\n", cbRef2);
      sb.Append("}\n</script>");
      cm.RegisterClientScriptBlock(this.GetType(), "OnLocationClick", sb.ToString());

      if (!Page.IsPostBack)
         PopulateCompanies();
   }

   void PopulateCompanies()
   {
      SqlConnection conn =
        new SqlConnection(
        "Data Source=localhost; Initial Catalog=SampleDB; Integrated Security=SSPI;");
      conn.Open();
      SqlCommand cmd = conn.CreateCommand();
      cmd.CommandText = "SELECT CompanyID, Description FROM Companies";
      DataTable companies = new DataTable("Companies");
      SqlDataAdapter da = new SqlDataAdapter(cmd);
      da.Fill(companies);
      lbCompany.DataTextField = "Description";
      lbCompany.DataValueField = "CompanyID";
      lbCompany.DataSource = companies;
      lbCompany.DataBind();
   }
}
